<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag;

use Erlage\Photogram\Data\Query;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagTable;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagPostTable;

final class HashtagModelHelper
{
    public static function updateCachePostsCount(HashtagModel $hashtagModel): void
    {
        $currentCount = (new Query())
            -> from(HashtagPostTable::TABLE_NAME)
            -> where(HashtagPostTable::HASHTAG_ID, $hashtagModel -> getId())
            -> count();

        $hashtagModel -> update(array(
            HashtagTable::CACHE_POSTS_COUNT => $currentCount,
        ));

        $hashtagModel -> save();
    }
}
